* Replication files for
* "Capital Reallocation and the Cyclicality of Aggregate Productivity" by Russ Cooper & Immo Schott
* Prepared: May 2023

***************************************************************
***************************************************************
* Compute reallocation moments at the firm level
***************************************************************
***************************************************************

use Compustat_coopimmo.dta, clear
* Reallocation = sum of sales of property, plant, & equipement (sppe) and acquisitions (aqc)

* Capital reallocation
gen R = aqc + sppe
replace R = . if aqc < 0 | sppe < 0 
lab var R "Capital reallocation"

* Fraction of adjusters
gen adj_R = 0 
replace adj_R = 1 if (aqc > 0 & aqc < .) | (sppe > 0 & sppe < . )
lab var adj_R "Dummy: Capital reallocation"

* Capital reallocation as a fraction of capital
gen RK = R / l.ppent 
lab var RK "Reallocation over capital"
